<?php

namespace App\Modules\TempApplication\Migrations\CustomerBankAccount;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerBankAccount extends Model 
{

    protected $table = 'tmp_customer_bank_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

}